import subprocess
import tkinter as tk
from tkinter import ttk

# Função para iniciar o QEMU com as opções selecionadas
def start_qemu(vm_image, cpu_type, bootloader, kernel, customization):
    qemu_cmd = ['qemu-system-' + cpu_type]

    # Adiciona opções específicas conforme selecionado na GUI
    if bootloader:
        qemu_cmd.extend(['-boot', bootloader])
    if kernel:
        qemu_cmd.extend(['-kernel', kernel])
    if customization:
        qemu_cmd.extend(customization.split())  # Adiciona outras opções de customização

    qemu_cmd.extend(['-hda', vm_image])  # Sempre inclui o caminho da imagem da VM

    subprocess.run(qemu_cmd)

# Função para gerar e exibir o comando QEMU completo
def generate_qemu_command():
    vm_image = entry_vm_image.get()
    cpu_type = combo_cpu_type.get()
    bootloader = combo_bootloader.get() if combo_bootloader.get() != 'Nenhum' else None
    kernel = entry_kernel.get() if entry_kernel.get() else None
    customization = entry_customization.get() if entry_customization.get() else None

    qemu_cmd = ['qemu-system-' + cpu_type]

    if bootloader:
        qemu_cmd.extend(['-boot', bootloader])
    if kernel:
        qemu_cmd.extend(['-kernel', kernel])
    if customization:
        qemu_cmd.extend(customization.split())

    qemu_cmd.extend(['-hda', vm_image])

    # Exibe o comando gerado na interface ou pode ser usado para execução direta posteriormente
    text_qemu_command.delete('1.0', tk.END)
    text_qemu_command.insert(tk.END, ' '.join(qemu_cmd))

# Interface gráfica usando Tkinter
root = tk.Tk()
root.title("Lukintosh OS Maker")

# Caminho da imagem da VM
label_vm_image = ttk.Label(root, text="Caminho da Imagem da VM:")
label_vm_image.pack(pady=5)
entry_vm_image = ttk.Entry(root, width=50)
entry_vm_image.pack(pady=5)

# Tipo de CPU (menu suspenso)
label_cpu_type = ttk.Label(root, text="Tipo de CPU:")
label_cpu_type.pack(pady=5)
combo_cpu_type = ttk.Combobox(root, values=['x86_64', 'i386', 'arm', 'mips', 'ppc', 'sparc', 'riscv,', 'lucuz', 'lucuz64', 'lkt', 'lkt64', 'm68k', 'aarch64'])
combo_cpu_type.pack(pady=5)
combo_cpu_type.set('x86_64')  # Definindo o valor padrão

# Opções de bootloader (menu suspenso)
label_bootloader = ttk.Label(root, text="Bootloader:")
label_bootloader.pack(pady=5)
bootloader_options = ['Nenhum', 'a', 'c', 'd', 'n', 'once', 'floppy', 'hda', 'cdrom', 'network']
combo_bootloader = ttk.Combobox(root, values=bootloader_options)
combo_bootloader.pack(pady=5)
combo_bootloader.set('Nenhum')  # Definindo o valor padrão

# Opção de kernel (campo de entrada)
label_kernel = ttk.Label(root, text="Kernel:")
label_kernel.pack(pady=5)
entry_kernel = ttk.Entry(root, width=50)
entry_kernel.pack(pady=5)

# Outras customizações (campo de entrada)
label_customization = ttk.Label(root, text="Outras Customizações:")
label_customization.pack(pady=5)
entry_customization = ttk.Entry(root, width=50)
entry_customization.pack(pady=5)

# Botão para gerar o comando QEMU
btn_generate_qemu_command = ttk.Button(root, text="Gerar Comando QEMU", command=generate_qemu_command)
btn_generate_qemu_command.pack(pady=10)

# Área de exibição do comando QEMU gerado
label_qemu_command = ttk.Label(root, text="Comando QEMU Gerado:")
label_qemu_command.pack(pady=5)
text_qemu_command = tk.Text(root, height=4, width=70)
text_qemu_command.pack(pady=5)

# Botão para iniciar o QEMU com as opções selecionadas
btn_start_qemu = ttk.Button(root, text="Iniciar QEMU", command=lambda: start_qemu(entry_vm_image.get(), combo_cpu_type.get(), combo_bootloader.get(), entry_kernel.get(), entry_customization.get()))
btn_start_qemu.pack(pady=10)

# Execução da interface gráfica
root.mainloop()
